/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.view.mindmapview.EdgeView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class SharpBezierEdgeView
extends EdgeView {
    CubicCurve2D.Float line1 = new CubicCurve2D.Float();
    CubicCurve2D.Float line2 = new CubicCurve2D.Float();
    GeneralPath graph = new GeneralPath();
    Point2D.Float one;
    Point2D.Float two;
    private static final int XCTRL = 12;

    public SharpBezierEdgeView(NodeView source, NodeView target) {
        super(source, target);
    }

    public void update() {
        super.update();
        if (this.target.isLeft()) {
            this.one = new Point2D.Float(this.start.x - 12, this.start.y);
            this.two = new Point2D.Float(this.end.x + 12, this.end.y);
        } else {
            this.one = new Point2D.Float(this.start.x + 12, this.start.y);
            this.two = new Point2D.Float(this.end.x - 12, this.end.y);
        }
        int w = this.getWidth() / 2 + 1;
        int w2 = w / 2;
        int dy1 = this.getSourceShift();
        this.line1.setCurve(this.start.x, this.start.y + dy1 - w, this.one.x, this.one.y + (float)dy1 - (float)w, this.two.x, this.two.y - (float)w2, this.end.x, this.end.y);
        this.line2.setCurve(this.end.x, this.end.y, this.two.x, this.two.y + (float)w2, this.one.x, this.one.y + (float)dy1 + (float)w, this.start.x, this.start.y + dy1 + w);
        this.graph.reset();
        this.graph.append(this.line1, true);
        this.graph.append(this.line2, true);
        this.graph.closePath();
    }

    public void paint(Graphics2D g) {
        this.update();
        g.setColor(this.getColor());
        g.setPaint(this.getColor());
        g.setStroke(DEF_STROKE);
        this.setRendering(g);
        g.fill(this.graph);
        g.draw(this.graph);
        super.paint(g);
    }

    public Color getColor() {
        return this.getModel().getColor();
    }
}

