/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.controller.LastOpenedList;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuBar
extends JMenuBar {
    JMenu mapsmenu;
    JPopupMenu mapsPopupMenu;
    private JMenu filemenu;
    private JMenu editmenu;
    Controller c;
    private LinkedList lastOpenedItems = new LinkedList();
    ActionListener mapsMenuActionListener = new MapsMenuActionListener();
    ActionListener lastOpenedActionListener = new LastOpenedActionListener();

    public MenuBar(Controller controller) {
        this.c = controller;
        this.filemenu = new JMenu(this.c.getResourceString("file"));
        this.editmenu = new JMenu(this.c.getResourceString("edit"));
        this.add(this.filemenu);
        this.add(this.editmenu);
        this.mapsmenu = new JMenu(this.c.getResourceString("mindmaps"));
        this.mapsPopupMenu = new JPopupMenu(this.c.getResourceString("mindmaps"));
        this.add(this.mapsmenu);
        JMenu modesmenu = new JMenu(this.c.getResourceString("modes"));
        this.add(modesmenu);
        ModesMenuActionListener modesMenuActionListener = new ModesMenuActionListener();
        LinkedList keys = new LinkedList(this.c.getModes().keySet());
        ListIterator i = keys.listIterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            JMenuItem newItem = new JMenuItem(key);
            modesmenu.add(newItem);
            String keystroke = this.c.getFrame().getProperty("keystroke_mode_" + key);
            if (keystroke != null) {
                newItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
            }
            newItem.addActionListener(modesMenuActionListener);
        }
        this.filemenu.setMnemonic(70);
        this.mapsmenu.setMnemonic(77);
        JMenu helpmenu = new JMenu(this.c.getResourceString("help"));
        this.add(helpmenu);
        helpmenu.add(this.c.documentation);
        helpmenu.add(this.c.faq);
        helpmenu.add(this.c.license);
        helpmenu.add(this.c.about);
    }

    public void updateMapsMenu() {
        this.mapsPopupMenu.removeAll();
        this.mapsmenu.removeAll();
        if (this.c.getMapModuleManager().getMapModules() == null) {
            return;
        }
        LinkedList keys = new LinkedList(this.c.getMapModuleManager().getMapModules().keySet());
        Collections.sort(keys);
        ListIterator i = keys.listIterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            JMenuItem newItem = new JMenuItem(key);
            JMenuItem newPopupItem = new JMenuItem(key);
            newItem.addActionListener(this.mapsMenuActionListener);
            newPopupItem.addActionListener(this.mapsMenuActionListener);
            newItem.setMnemonic(key.charAt(0));
            newPopupItem.setMnemonic(key.charAt(0));
            if (this.c.getMapModuleManager().getMapModule() != null && key.equals(this.c.getMapModuleManager().getMapModule().toString())) {
                newItem.setBackground(Color.lightGray);
                newPopupItem.setBackground(Color.lightGray);
            }
            this.mapsPopupMenu.add(newPopupItem);
            this.mapsmenu.add(newItem);
        }
        this.mapsPopupMenu.addSeparator();
        JMenuItem newPopupItem = new JMenuItem(this.c.toggleMenubar);
        newPopupItem.setForeground(new Color(100, 80, 80));
        newPopupItem.setEnabled(this.c.getFrame().isApplet());
        this.mapsPopupMenu.add(newPopupItem);
        newPopupItem = new JMenuItem(this.c.toggleToolbar);
        newPopupItem.setForeground(new Color(100, 80, 80));
        this.mapsPopupMenu.add(newPopupItem);
        newPopupItem = new JMenuItem(this.c.toggleLeftToolbar);
        newPopupItem.setForeground(new Color(100, 80, 80));
        this.mapsPopupMenu.add(newPopupItem);
    }

    public void updateFileMenu() {
        this.filemenu.removeAll();
        if (this.c.getMode() != null && this.c.getMode().getModeFileMenu() != null) {
            this.copyMenuItems(this.c.getMode().getModeFileMenu(), this.filemenu);
        }
        this.filemenu.addSeparator();
        JMenuItem page = this.filemenu.add(this.c.page);
        JMenuItem print = this.filemenu.add(this.c.print);
        print.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_print")));
        this.filemenu.addSeparator();
        JMenuItem close = this.filemenu.add(this.c.close);
        close.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_close")));
        JMenuItem quit = this.filemenu.add(this.c.quit);
        quit.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_quit")));
        this.filemenu.addSeparator();
        this.updateLastOpenedList();
    }

    public void updateLastOpenedList() {
        ListIterator it = this.lastOpenedItems.listIterator();
        while (it.hasNext()) {
            this.filemenu.remove((JMenuItem)it.next());
        }
        this.lastOpenedItems.clear();
        boolean firstElement = true;
        LastOpenedList lst = this.c.getLastOpenedList();
        ListIterator it2 = lst.listIterator();
        while (it2.hasNext()) {
            JMenuItem item = new JMenuItem((String)it2.next());
            if (firstElement) {
                firstElement = false;
                item.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_open_first_in_history")));
            }
            item.addActionListener(this.lastOpenedActionListener);
            this.lastOpenedItems.add(item);
            this.filemenu.add(item);
        }
    }

    public void updateEditMenu() {
        this.editmenu.removeAll();
        if (this.c.getMode() != null && this.c.getMode().getModeEditMenu() != null) {
            this.copyMenuItems(this.c.getMode().getModeEditMenu(), this.editmenu);
        }
        this.editmenu.addSeparator();
        JMenuItem zoomIn = this.editmenu.add(this.c.zoomIn);
        zoomIn.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_zoom_in")));
        JMenuItem zoomOut = this.editmenu.add(this.c.zoomOut);
        zoomOut.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_zoom_out")));
        this.editmenu.addSeparator();
        JMenuItem moveToRoot = this.editmenu.add(this.c.moveToRoot);
        moveToRoot.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_moveToRoot")));
        JMenuItem previousMap = this.editmenu.add(this.c.navigationPreviousMap);
        previousMap.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_previousMap")));
        JMenuItem nextMap = this.editmenu.add(this.c.navigationNextMap);
        nextMap.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_nextMap")));
        this.editmenu.addSeparator();
        JMenu preferences = new JMenu(this.c.getResourceString("preferences"));
        this.editmenu.add(preferences);
        String antialiasSelected = this.c.getAntialiasAll() ? "antialias_all" : (this.c.getAntialiasEdges() ? "antialias_edges" : "antialias_none");
        this.addOptionSet(this.c.optionAntialiasAction, new String[]{"antialias_none", "antialias_edges", "antialias_all"}, preferences, antialiasSelected);
        preferences.addSeparator();
        this.addOptionSet(this.c.optionHTMLExportFoldingAction, new String[]{"html_export_no_folding", "html_export_fold_currently_folded", "html_export_fold_all", "html_export_based_on_headings"}, preferences, this.c.getProperty("html_export_folding"));
        preferences.addSeparator();
        this.addOptionSet(this.c.optionSelectionMechanismAction, new String[]{"selection_method_direct", "selection_method_by_click"}, preferences, this.c.getProperty("selection_method"));
    }

    private void addOptionSet(Action action, String[] textIDs, JMenu menu, String selectedTextID) {
        ButtonGroup group = new ButtonGroup();
        for (int optionIdx = 0; optionIdx < textIDs.length; ++optionIdx) {
            String keystroke;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.setText(this.c.getResourceString(textIDs[optionIdx]));
            item.setActionCommand(textIDs[optionIdx]);
            group.add(item);
            menu.add(item);
            if (selectedTextID != null) {
                item.setSelected(selectedTextID.equals(textIDs[optionIdx]));
            }
            if ((keystroke = this.c.getFrame().getProperty("keystroke_" + textIDs[optionIdx])) == null) continue;
            item.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        }
    }

    JPopupMenu getMapsPopupMenu() {
        return this.mapsPopupMenu;
    }

    private void copyMenuItems(JMenu source, JMenu dest) {
        Component[] items = source.getMenuComponents();
        for (int i = 0; i < items.length; ++i) {
            dest.add(items[i]);
        }
    }

    private class ModesMenuActionListener
    implements ActionListener {
        private ModesMenuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuBar.this.c.changeToMode(e.getActionCommand());
        }
    }

    private class LastOpenedActionListener
    implements ActionListener {
        private LastOpenedActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuBar.this.c.getLastOpenedList().open(e.getActionCommand());
        }
    }

    private class MapsMenuActionListener
    implements ActionListener {
        private MapsMenuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuBar.this.c.getMapModuleManager().changeToMapModule(e.getActionCommand());
        }
    }
}

